require('dotenv').config()

// const knex = require('knex')({
//     client: 'mysql',
//     connection: {
//         host: process.env.DBHOST,
//         user: process.env.DBUSER,
//         password: process.env.DBPASS,
//         database: process.env.DBNAME
//     }
// })

const knex = require('knex')({
    client: 'sqlite3',
    connection: {
      filename: '../mydb.sqlite' // Change this to the path where you want to store the SQLite database
    },
    useNullAsDefault: true
})

knex.schema.createTable('games', (table) => {
    table.increments('id').primary();
    table.string('name').nullable();
    table.text('description');
    table.string('thumbnail').nullable();
    table.string('bannerImage').nullable();
    table.string('logo').nullable();
    table.string('link').nullable();
    table.integer('like').defaultTo(0);
    table.string('category').nullable();
    table.timestamp("createdAt").nullable();
    table.timestamp("expiresAt").nullable();
}).then(() => {
    console.log('Table created successfully: games');
}).catch((error) => {
    console.error('Error creating table:', error.sqlMessage);
})



.finally(() => {
    knex.destroy();
});
